<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Generate a temporaty XML file from the invoice data
 * @param $invoice
 * @param $items
 * @return string
 */
function generate_invoice_zugferd_xml_temp_file($invoice, $items)
{
    $CI = &get_instance();
    $CI->load->helper('file');


    $path = UPLOADS_TEMP_FOLDER . 'invoice_' . $invoice->invoice_id . '_zugferd.xml';
    $CI->load->library('zugferdXml', array('invoice' => $invoice, 'items' => $items));

    write_file($path, $CI->zugferdxml->xml());
    return $path;
}
/**
 * Generate a temporaty XML file from the invoice data
 * @param $expense
 * @param $items
 * @return string
 */
function generate_expense_zugferd_xml_temp_file($expense, $items)
{
    $CI = &get_instance();
    $CI->load->helper('file');


    $path = UPLOADS_TEMP_FOLDER . 'expense_' . $expense->expense_id . '_zugferd.xml';
    $CI->load->library('zugferdXml', array('expense' => $expense, 'items' => $items));

    write_file($path, $CI->zugferdxml->xml());
    return $path;
}

/**
 * Returns the correct RDF string for the Zugferd XML
 * @return string
 */
function zugferd_rdf()
{
    $s = '<rdf:Description rdf:about="" xmlns:zf="urn:ferd:pdfa:CrossIndustryDocument:invoice:1p0#">' . "\n";
    $s .= '  <zf:DocumentType>INVOICE</zf:DocumentType>' . "\n";
    $s .= '  <zf:DocumentFileName>ZUGFeRD-invoice.xml</zf:DocumentFileName>' . "\n";
    $s .= '  <zf:Version>1.0</zf:Version>' . "\n";
    $s .= '  <zf:ConformanceLevel>COMFORT</zf:ConformanceLevel>' . "\n";
    $s .= '</rdf:Description>' . "\n";
    return $s;
}




